package ga.examples.quadratic;

import ga.core.algorithm.util.RandomSingleton;
import ga.core.individual.IIndividual;
import ga.core.validation.GAContext;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;

public final class QuadraticIndividual implements
    IIndividual<QuadraticIndividual> {
  public static final int MAX_NUM = 8;
  public static final int PARAMETER_COUNT = 3;

  private static final AtomicLong ID_GENERATOR = new AtomicLong();

  private final long id;

  private transient double fitness = UNEVALUATED;
  private transient int result = Integer.MIN_VALUE;
  private final List<Integer> genotype = new ArrayList<Integer>();

  private final Random rnd = RandomSingleton.getRandom();

  public QuadraticIndividual() {
    id = ID_GENERATOR.incrementAndGet();
  }

  @Override
  public long getId() {
    return id;
  }

  @Override
  public void setContext(final GAContext context) {
  }

  @Override
  public GAContext getContext() {
    return null;
  }

  @Override
  public void initRandomly() {
    fitness = UNEVALUATED;
    genotype.clear();

    for (int i = 0; i < PARAMETER_COUNT; i++) {
      genotype.add(rnd.nextInt(MAX_NUM + 1));
    }
  }

  @Override
  public void setFitness(final double fitness) {
    this.fitness = fitness;
  }

  @Override
  public double getFitness() {
    if (!isEvaluated()) {
      throw new RuntimeException("Not evaluated individual");
    }
    return fitness;
  }

  public List<Integer> getGenotype() {
    return genotype;
  }

  @Override
  public String toString() {
    String s = genotype.get(0) + "^2*" + genotype.get(1) + "+"
        + genotype.get(2);

    s += isEvaluated() ? ("=" + result + " Fitness: " + fitness)
        : " unevaluated";
    return s;
  }

  public void setResult(final int result) {
    this.result = result;
  }

  public int getResult() {
    return result;
  }

  @Override
  public boolean isEvaluated() {
    return fitness != UNEVALUATED;
  }

  @Override
  public QuadraticIndividual clone() {
    final QuadraticIndividual ind = new QuadraticIndividual();
    ind.genotype.addAll(this.genotype);
    return ind;
  }

}
